const error = require('../classes/error.js');
const logger = require('../api/logger');
const MatchController = require('../controllers/match');
const asyncMiddleware = require('../classes/async-middleware');
const AuthenticatedUser = require('../middleware/authenticated_user');
const Broadcast = require('../api/broadcast');

module.exports = {

  route: '/match/cancel',
  wrapper: AuthenticatedUser,
  post: asyncMiddleware(async function(req, res, next) {
    const match_id = req.body.match_id;
    const user_id = req.acting_user.user_id;

    const match = await MatchController.getOwnMatch(match_id, user_id);

    if (!match) {
      logger.error("can't find match", match_id);
      throw new error.BadRequest("can't find match for user");
    }

    if (match.state !== 'waiting' && match.state !== 'created') {
      logger.info(`Can't cancel request in "${match.state}" state`);
      throw new error.Conflict(`Can't cancel request in "${match.state}" state`);
    }

    Broadcast.emit('/match/cancel', match_id, {result: [{url: "/match/cancel", match_id, user_id}]});
    return next();
  })
};
