const error = require('../classes/error');
const logger = require('../api/logger');
const TarlyController = require('../classes/tarly_controller');
const MatchController = require('../controllers/match');
const asyncMiddleware = require('../classes/async-middleware');
const admin_wrapper = require('../classes/admin_wrapper');

module.exports = {
  route: '/match/end',
  wrapper: admin_wrapper,
  post: asyncMiddleware(async function(req, res, next) {
    const match_id = req.body.match_id;
    const cancel = req.body.cancel || false;
    const set_id = req.body.set_id;

    const match = await TarlyController.getModel('match').findById(match_id);

    if (!match) {
      logger.error("can't find match", match_id);
      throw new error.BadRequest("can't find match for user");
    }

    const newMatch = await MatchController.endMatch(match, cancel, set_id);

    res.result = [newMatch];
    return next();
  })
};
