const MatchController = require('../controllers/match');
const asyncMiddleware = require('../classes/async-middleware.js');
const AdminWrapper = require('../classes/admin_wrapper');


module.exports = {
  route: '/match/expired',
  wrapper: AdminWrapper,
  get: asyncMiddleware(async function(req, res, next) {

    res.result = await MatchController.getExpired(req.query.count);
    next();
  })
};
