const logger = require('../api/logger');
const error = require('../classes/error.js');
const MatchController = require('../controllers/match');
const TarlyController = require('../classes/tarly_controller');
const asyncMiddleware = require('../classes/async-middleware.js');
const admin_wrapper = require('../classes/admin_wrapper.js');

module.exports = {
  route: '/match/finder',
  wrapper: admin_wrapper,
  post: asyncMiddleware(async function(req, res, next) {
    const match_id = req.body.match_id;

    const match = await TarlyController.getModel('match').findById(match_id);

    if (!match) {
      logger.error("can't find match", match_id);
      throw new error.BadRequest("can't find match for user");
    }

    if (match.state !== 'started') {
      logger.info(`Can't find match in "${match.state}" state`);
      throw new error.Conflict(`Can't find in "${match.state}" state`);
    }

    const oldMatch = await MatchController.reserveMatch(match);

    res.result = [oldMatch];
    return next();
  })
};
