const error = require('../classes/error.js');
const logger = require('../api/logger');
const MatchController = require('../controllers/match');
const asyncMiddleware = require('../classes/async-middleware');
const AuthenticatedUser = require('../middleware/authenticated_user');
const Broadcast = require('../api/broadcast');
const TarlyController = require('../classes/tarly_controller');
const MatchModel = TarlyController.getModel('match');

module.exports = {
  route: '/match/forfeit',
  wrapper: AuthenticatedUser,
  post: asyncMiddleware(async function(req, res, next) {
    const match_id = req.body.match_id;
    let user_id = req.acting_user.user_id;
    let ended_dttm = null;

    let match = null;
    logger.debug("forfeit - is_admin", req.is_admin);
    if (req.is_admin) {
      match = await MatchModel.findById(match_id);
      user_id = req.body.user_id;
      ended_dttm = req.body.ended_dttm;
    } else {
      match = await MatchController.getOwnMatch(match_id, user_id);
    }

    if (!match) {
      logger.error("can't find match", match_id);
      throw new error.BadRequest("can't find match for user");
    }

    //conditions to allow forfeit are:
    //match.state === started
    //match.state === waiting && match.tournament_id IS NOT NULL
    // TODO - we should make tinder use a different call for tournaments....
    if (!req.is_admin && match.state !== 'started' && !(match.state === 'waiting' && match.tournament_id)) {
      logger.info(`Can't forfeit request in "${match.state}" state`);
      throw new error.Conflict(`Can't forfeit in "${match.state}" state`);
    }

    const msg = {
      result: [
        {
          url: '/match/forfeit',
          match_id,
          user_id
        }
      ]
    };
    if (ended_dttm) {
      msg.result[0].ended_dttm = ended_dttm;
    }

    Broadcast.emit('/match/forfeit', match_id, msg);
    return next();
  })
};
