const MatchController = require('../controllers/match');
const asyncMiddleware = require('../classes/async-middleware');
const AuthenticatedUser = require('../middleware/authenticated_user');

module.exports = {
  route: '/match/team',
  wrapper: AuthenticatedUser,
  get: asyncMiddleware(async function(req, res, next) {
    const team_id = req.query.team_id;

    const matches = await MatchController.getMatchesForWeek(team_id);
    res.result = matches;
    next();
  })
};
