const error = require('../classes/error.js');
const logger = require('../api/logger');
const Service = require('../models/service.js');

const ServiceHandler = {
  route: '/service',

  get: (req, res, next) => {
    if (!req.is_admin) {
      return next(new error.Unauthorized('invalid_permission'));
    }

    return Service.get()
      .then(services => {
        res.result = services;
        next();
      })
      .catch(err => {
        logger.error(err);
        next(new error.DefaultError(err));
      });
  },

  post: (req, res, next) => {
    if (!req.is_admin) {
      return next(new error.Unauthorized('invalid_permission'));
    }
    let serviceObj = req.body;
    serviceObj.owner_id = req.acting_user ? req.acting_user.user_id : 'admin';
    return Service.post(req.body)
      .then((service) => {
        res.result = service;
        next();
      })
      .catch(err => {
        logger.error(err);
        next(new error.DefaultError(err));
      });
  }
};

module.exports = ServiceHandler;
