const error = require('../classes/error');
const asyncMiddleware = require('../classes/async-middleware.js');

const AuthenticatedUser = require('../middleware/authenticated_user');

const UserController = require('../controllers/user');

const Subscribe = {
  route: '/subscribe/user',
  wrapper: AuthenticatedUser, 
  get: asyncMiddleware(async function(req, res, next) {

    const { user_id  } = req.acting_user;
    const user = await UserController.findByPk(user_id, { useMaster: false });
    if (user) {
      res.result = [user];
    } else {
      return next(new error.NotFound('unknown user_id'));
    }

    next();
  })
};

module.exports = Subscribe;
