const TarlyController = require('../classes/tarly_controller');
const _ = require('lodash');

const error = require('../classes/error.js');
const asyncMiddleware = require('../classes/async-middleware.js');

module.exports = {

  route: '/tournament/bracket',
  get: asyncMiddleware(async function(req, res, next) {
    if(!req.acting_user && !req.is_admin){
      return next(new error.Forbidden("need to be a user or admin"));
    }

    const matchModel = TarlyController.getModel('match');
    const setModel = TarlyController.getModel('set');
    const userModel = TarlyController.getModel('user');
    const teamModel = TarlyController.getModel('team');

    let opts = _.cloneDeep(req.sqlOptions);
    opts.include = _.cloneDeep(matchModel.config.include);
    opts.useMaster = true;
    opts.order = [
      ["tournament_bracket","DESC"],
      ["tournament_seed", "ASC"]];
    let where = opts.where;
    if (!where || (where.tournament_id == null && where.match_id == null && where.division_id == null)) {
      throw new error.BadRequest('match_id, division_id or tournament_id required');
    }
    let user_id = where.user_id;
    if (user_id) {
      delete where.user_id;
      opts.include.push({
        required: true,
        model: setModel.model,
        as: 'owner',
        through: { attributes: [] },
        include: [
          {
            required: true,
            model: teamModel.model,
            as: 'team',
            include: [
              {
                required: true,
                model: userModel.model,
                where: { user_id },
                through: { attributes: [] }
              }
            ]
          }
        ]
      });
    }

    let tournament_matches = await matchModel.findAll2(opts);
    res.result = tournament_matches;
    return next();
  }),
};

