const asyncMiddleware = require('../classes/async-middleware.js');
const admin_wrapper = require('../classes/admin_wrapper.js');
const Broadcast = require('../api/broadcast');

const UserMe = {
  route: '/tournament/storm/move',
  wrapper: admin_wrapper,
  post: asyncMiddleware(async function(req, res, next) {
    let tournament_id = req.body.tournament_id;
    let round = req.body.round;
    let match_id = req.body.match_id;
    await Broadcast.emit('/tournament/storm/move', tournament_id, 
      {result: [{url: "/tournament/storm/move", tournament_id, round, match_id}]});
    next();
  })
};

module.exports = UserMe;
