const TarlyController = require('../classes/tarly_controller');
const admin_wrapper = require('../classes/admin_wrapper.js');

const error = require('../classes/error.js');
const asyncMiddleware = require('../classes/async-middleware.js');
const _ = require('lodash');

module.exports = {

  route: '/tournament/team',
  get: asyncMiddleware(async function(req, res, next) {

    if(!req.acting_user && !req.is_admin){
      return next(new error.Forbidden("need to be a user or admin"));
    }

    const ttModel = TarlyController.getModel('tournament_team');
    const TeamModel = TarlyController.getModel('team');
    const UserModel = TarlyController.getModel('user');

    let opts = _.cloneDeep(req.sqlOptions);
    opts.include = _.cloneDeep(ttModel.config.include);
    opts.include = [{
      model: TeamModel.model,
      attributes: ["team_id", "name"],
      include: {
        model: UserModel.model,
        through: { attributes: [] },
        attributes: ['username', 'user_id', 'image_url'],
      }
    }];
    let tournament_teams = await ttModel.findAll2(opts);
    let teams = tournament_teams.map((tt) => {
      let team = tt.get().team;
      team.rank = tt.rank;
      team.seed = tt.seed;
      team.registered_dttm = tt.registered_dttm;
      team.checkin_dttm = tt.checkin_dttm;
      team.tournament_team_id = tt.tournament_team_id;
      return team;
    });

    res.result = teams;
    return next();
  }),

  post: asyncMiddleware(async function(req, res, next) {
    if(!req.is_admin){
      return next(new error.Forbidden("only admins can add teams"));
    }
    const model = TarlyController.getModel('tournament_team');

    try {
      let tt = await model.create(Object.assign({}, req.body, { user_id: "service", owner_id: "service"}));
      res.result = [ tt ];
      return next();
    } catch (err) {
      if (err.name !== "SequelizeUniqueConstraintError") {
        return next(new error.DefaultError(err));
      }
    }

    let where = {
      team_id: req.body.team_id,
      tournament_id: req.body.tournament_id};
    let updateObj = Object.assign({}, req.body);
    delete updateObj.team_id;
    delete updateObj.tournament_id;

    let tt = await model.updateWhere(updateObj, where, false, true);
    res.result = [ tt ];
    return next();
  }),
  put: asyncMiddleware(async function(req, res, next) {
    return module.exports.post(req, res, next);
  })

};

