const TarlyController = require('../classes/tarly_controller');
const asyncMiddleware = require('../classes/async-middleware');
const error = require('../classes/error.js');
const logger = require('../api/logger');
const TeamModel = TarlyController.getModel('team');
const TournamentTeamModel = TarlyController.getModel('tournament_team');
const TournamentModel = TarlyController.getModel('tournament');

const getTournamentTeam = async function (tournament_team_id, req, res, next) {

  // const tt = await TournamentTeamModel.findById(tournament_team_id);
  const tt= await TournamentTeamModel.model.findByPk(tournament_team_id, {
    useMaster: true,
    include: TournamentTeamModel.config.include,
    paranoid: true,
    raw: false
  });

  if (! tt) {
    return null;
  }

  const tournament = await TournamentModel.findById(tt.tournament_id);

  if (tournament.state !== "created") {
    return next(new error.Conflict("can't modify tournament in current state"));
  }

  const team = await TeamModel.findById(tt.team_id);
  if (! team) {
    return next(new error.NotFound("team not found"));
  }

  const is_member = team.users.some(
    (u) => {
      return u.user_id === req.acting_user.user_id;
    });

  if (!req.is_admin && ! is_member) {
    return next(new error.Forbidden("must be member"));
  }
  return tt;
};

module.exports = {
  route: '/tournament/team/checkin',
  post: asyncMiddleware(async function(req, res, next) {

    const tournament_team_id = req.body.tournament_team_id;
    const team_id = req.body.team_id;
    const tournament_id = req.body.tournament_id;

    let tt = null;
    if (tournament_team_id) {
      tt = await getTournamentTeam(tournament_team_id, req, res, next);
    }

    if (tt == null) {

      const team = await TeamModel.findById(team_id);
      if (! team) {
        return next(new error.NotFound("team not found"));
      }

      const tournament = await TournamentModel.findById(tournament_id);

      if (! tournament) {
        return next(new error.NotFound("tournament not found"));
      }

      if (tournament.state !== "created") {
        return next(new error.Conflict("can't modify tournament in current state"));
      }

      const is_member = team.users.some(
        (u) => {
          return u.user_id === req.acting_user.user_id;
        });

      if (!req.is_admin && ! is_member) {
        return next(new error.Forbidden("must be member"));
      }

      tt = await TournamentTeamModel.model.findOne({
        where: { tournament_id, team_id},
        useMaster: true,
        include: TournamentTeamModel.config.include,
        paranoid: true,
        raw: false
      });

      if (! tt) {
        tt = await TournamentTeamModel.create({
          team_id,
          tournament_id,
          checkin_dttm: new Date(),
        });
      }
    }

    if (tt.checkin_dttm == null) {
      tt.checkin_dttm = new Date();
      await tt.save();
    }
    res.result = [tt];
    return next();

  }),
  delete: asyncMiddleware(async function(req, res, next) {
    const tournament_team_id = req.query.tournament_team_id;
    const tt = await getTournamentTeam(tournament_team_id, req, res, next);
    if (! tt) {
      return next(new error.NotFound("tournament team not found"));
    }

    if (tt.checkin_dttm != null) {
      tt.checkin_dttm = null;
      await tt.save();
    }

    res.result = [tt];
    return next();
  })
};
