const error = require('../classes/error.js');
const logger = require('../api/logger');
const config = require('../config.js');

const SMS = require('../classes/sms');

const MsgAuditModel = require('../classes/tarly_controller').getModel('msg_audit');

const TwilioCallbackHandler = {
  route: '/twilio/callback',

  post: (req, res, next) => {


    logger.info(req.body);
    const { AccountSid: account_sid, MessageSid: external_id } = req.body;
    if (!external_id) {
      return next(new error.BadRequest('missing external_id in body'));
    }

    if (!account_sid) {
      return next(new error.BadRequest('missing account_sid in body'));
    }

    if (account_sid !== config.TWILIO_ACCOUNT_SID) {
      return next(new error.Forbidden('account_sid in body does not match configured account_sid'));
    }

    return MsgAuditModel.findOne({ external_id, type: 'twilio' }, false)
      .then(message => message ? message : Promise.reject(new error.NotFound('unknown external_id')))
      .then(message => SMS.upsertMessage(Object.assign({}, req.body, { msg_audit_id: message.msg_audit_id, updated_dttm: Date.now() })))
      .then(() => {
        return next();
      })
      .catch(err => {
        logger.error(err);
        next(new error.DefaultError(err));
      });
  }
};

module.exports = TwilioCallbackHandler;
