const Analytics = require('../classes/analytics');
const AuthenticatedUser = require('../middleware/authenticated_user');
const TarlyController = require('../classes/tarly_controller');
const UserController = require('../controllers/user');
const asyncMiddleware = require('../classes/async-middleware.js');
const error = require('../classes/error.js');

const ALLOWED = new Set(
  ['username', 'bio', 'mixer_username', 'user_id', 'image_url', 'has_pc', 'has_xbox', 'has_ps4', 'current_platform']);

module.exports = {
  route: '/user',
  wrapper: AuthenticatedUser, 
  put: asyncMiddleware(async function(req, res, next) {

    let user_id = req.acting_user.user_id;
    if (!req.isAdmin) {
      if (req.body.user_id) {
        if(req.body.user_id !== user_id) {
          return next(new error.Forbidden("wrong user_id"));
        }
        delete req.body.user_id;
      }
      for (let key of Object.keys(req.body)) {
        if (! ALLOWED.has(key)) {
          return next(new error.Forbidden(`user forbidden to change ${key}`));
        }
      }
    } else {
      if (req.body.user_id) {
        user_id = req.body.user_id;
      }
    }

    const userModel = TarlyController.getModel('user');

    let updateObj = Object.assign({}, req.body);
    let username = updateObj.username;
    if (username) {
      username = UserController.normalizeUsername(username);
      updateObj.username = username;

      let otherUser = await userModel.model.findOne({where: {username: username}, paranoid: true});
      if (otherUser) {
        return next(new error.Conflict('username taken'));
      }
    }

    let user = await userModel.updateById(user_id, updateObj, false);
    if (! user) {
      return (next(new error.NotFound("user not found")));
    }
    
    user = await UserController.findByPk(user_id);
    if (req.body.has_pc) {
      Analytics.track("user", "platform", "pc", null, {user});
    }
    if (req.body.has_xbox) {
      Analytics.track("user", "platform", "xbox", null, {user});
    }
    if (req.body.has_ps4) {
      Analytics.track("user", "platform", "ps4", null, {user});
    }
    res.result = [user];
    return next();

  }),

  get: asyncMiddleware(async function(req, res, next) {

    const userModel = TarlyController.getModel('user');
    let users = await userModel.findAll2(req.sqlOptions);
    res.result = users;
    return next();
  })
};

