const error = require('../classes/error');
const TarlyController = require('../classes/tarly_controller');
const UserController = require('../controllers/user');
const asyncMiddleware = require('../classes/async-middleware');
const admin_wrapper = require('../classes/admin_wrapper');

module.exports = {
  route: '/user/active/match',
  wrapper: admin_wrapper,
  delete: asyncMiddleware(async function(req, res, next) {
    const UserModel = TarlyController.getModel('user');
    const match_id = req.query.match_id;
    const user_id = req.query.user_id;

    if (user_id == null || match_id == null) {
      throw new error.BadRequest("user_id or match_id null");
    }

    const where = {user_id, active_match_id: match_id};
    await UserModel.updateWhere({ active_match_id: null, current_platform: null }, where);
    await UserController.emit(user_id);
    res.result = [];
    return next();
  })
};
