// const admin_wrapper = require('../classes/admin_wrapper.js');
const owner_wrapper = require('../classes/owner_auth.js');

const error = require('../classes/error.js');
const logger = require('../api/logger');

const UserSocialModel = require('../models/user_social.js');

const RTMP_SERVICES = new Set(['youtube', 'twitch']);


const Handler = {
  route: '/user/egress',
  wrapper: owner_wrapper,
  get: async function (req, res, next) {
    let { active } = req.query;
    logger.info("HELP active?", req.query);
    if (!req.acting_user) {
      return next(new error.Unauthorized());
    }
    const user_id = req.acting_user.user_id;

    let where = {user_id};
    if (active != null) {
      if (active === '') {
        active = true;
      }
      where.active = active;
    }

    var items = await UserSocialModel.findAll({
      where,
      attributes: ['type', 'user_id', 'active', 'data'],
      raw: true
    });

    items = items.filter(o => RTMP_SERVICES.has(o.type));

    for (const us of items) {
      if (us.type == 'youtube') {
        // us.type = us.data.ingest.type;
        us.key = us.data.ingest.key;
        us.urls = [us.data.ingest.address, us.data.ingest.backup_address];
        us.name = us.data.display_name;
      } else if (us.type == 'twitch') {
        // us.type = "rtmp";
        us.key = us.data.stream_key;
        us.name = us.data.name;
        us.urls = null;
      }
      delete us.data;
    }

    logger.debug(items);
    res.result = items;
    next();
  },

  put: async function (req, res, next) {
    const { type, active } = req.body;
    let user_id = null;
    if (req.acting_user) {
      user_id = req.acting_user.user_id;
    }

    if (!user_id) {
      return next(new error.BadRequest('missing user_id'));
    }

    if (active == null) {
      return next(new error.BadRequest('missing active'));
    }

    if (type == null) {
      return next(new error.BadRequest('missing type'));
    }

    await UserSocialModel.update(
      {active, updated_dttm: Date.now()},
      {where: {user_id, type}});


    var items = await UserSocialModel.findAll({
      where: {user_id},
      attributes: ['stream_id', 'type', 'user_id', 'active', 'data'],
      useMaster: true,
      raw: true
    });
    items = items.filter(o => RTMP_SERVICES.has(o.type));

    for (const us of items) {
      if (us.type == 'youtube') {
        // us.type = us.data.ingest.type;
        us.key = us.data.ingest.key;
        us.urls = [us.data.ingest.address, us.data.ingest.backup_address];
        us.name = us.data.display_name;
      } else if (us.type == 'twitch') {
        // us.type = "rtmp";
        us.key = us.data.stream_key;
        us.name = us.data.name;
        us.urls = null;
      }
      delete us.data;
    }

    logger.debug(items);
    res.result = items;
    next();
  }
};

module.exports = Handler;
