const AuthenticatedUser = require('../middleware/authenticated_user');
const TarlyController = require('../classes/tarly_controller');
const UserGameController = require('../controllers/user_game');
const asyncMiddleware = require('../classes/async-middleware');

module.exports = {
  route: '/user/game',
  wrapper: AuthenticatedUser,
  post: asyncMiddleware(async function(req, res, next) {
    const user_id = req.acting_user.user_id;
    const now_dttm = new Date();
    await UserGameController.endOpenGames(user_id, now_dttm);
    req.body.started_dttm  = now_dttm;
    return TarlyController.getHandler('user_game').post(req, res, next);
  }),
  get: function(req, res, next) {
    return TarlyController.getHandler('user_game').get(req, res, next);
  },
  put: function(req, res, next) {
    return TarlyController.getHandler('user_game').put(req, res, next);
  },
  delete: function(req, res, next) {
    return TarlyController.getHandler('user_game').delete(req, res, next);
  }
};
