const logger = require('../api/logger');
const TarlyController = require('../classes/tarly_controller');
const cache = require('bebo-node-commons').RedisCache;
const uuid = require('uuid');
const UserGameController = require('../controllers/user_game');

const asyncMiddleware = require('../classes/async-middleware');
const AuthenticatedUser = require('../middleware/authenticated_user');

const UserGameModel = TarlyController.getModel('user_game');

const writer = cache.getWriteClient();
const reader = cache.getReadClient();

const getKey = (user_id) => {
  return `user_game:${user_id}`;
};

module.exports = {
  route: '/user/gamestate',
  wrapper: AuthenticatedUser,
  post: asyncMiddleware(async function(req, res, next) {
    // FIXME: user_id from body could be set by anyone
    const {label, user_id, prob} = req.body;
    logger.info(`gamestate  label: ${label} prob: ${prob}`);

    const acting_user = req.acting_user;
    if(acting_user.current_platform !== "xbox"){
      return next();
    }

    if(label === 'game') {
      logger.info("label === game, user_id", user_id);
      let game_id = await reader.getAsync(getKey(user_id));
      logger.info("redis game_id", game_id);
      if(!game_id){
        try{
          game_id = uuid.v4();
          const now_dttm = new Date();
          await UserGameController.endOpenGames(user_id, now_dttm);
          await UserGameModel.model.create({
            owner_id: user_id,
            user_game_id: game_id,
            user_id: user_id,
            started_dttm: now_dttm
          });

          await writer.setAsync(getKey(user_id), game_id, 'EX', 60 * 30);
          const userGame = await UserGameModel.findById(game_id);
          res.result = [userGame.dataValues];
        }catch(err){
          logger.error("failed to write user_game", err);
        }
      }
    }else if(label === "lobby"){
      logger.info("label === lobby, user_id", user_id);
       let game_id = await reader.getAsync(getKey(user_id));
       if(game_id){
         logger.info("ending game for game_id", game_id);
         try{
           await writer.setAsync(getKey(user_id), "", 'EX', 1);
           await UserGameModel.model.update({
             ended_dttm:  Date.now(),
             updated_dttm: Date.now()
           }, {
             where: { user_game_id: game_id }
           });
           const userGame = await UserGameModel.findById(game_id);
           res.result = [userGame.dataValues];
         }catch(err){
           logger.error("failed to write user_game", err);
         }
       }
    }


    next();
  })
};
