const asyncMiddleware = require('../classes/async-middleware.js');
const SMS = require('../classes/sms');
const error = require('../classes/error.js');

const UserController = require('../controllers/user');


const UserLogin = {
  route: '/user/login',
  post: asyncMiddleware(async function(req, res, next) {

    let {phone_number, username, password, pin } = req.body;
    let phone;

    if (phone_number) {
      phone = SMS.parsePhoneNumber(phone_number);
      if (!phone) {
        return next(new error.BadRequest('invalid phone number'));
      }
    }

    if (!username && !phone) {
      return next(new error.BadRequest("Requires username or phone_number"));
    }

    if (phone) {

      if (!pin) {
        await UserController.sendValidationSMS(phone, {});
        let message = UserController.formatPinMessage(phone);
        res.result = [{ message, require: ["pin"]}];
        res.code = 202;
        return next();
      } else {
        let user = await UserController.loginWithPhoneNumber(phone, pin, req.platform);
        res.result = [user];
        req.acting_user = user;
        return next();
      }
    }

    if (! password) {
      let message = "Please enter your password";
      res.result = [{message, require: ["password"]}];
      res.code = 202;
      return next();
    }

    let user = await UserController.loginWithPassword(username, password, req.platform);
    req.acting_user = user;
    res.result = [user];
    return next();

  })
};

module.exports = UserLogin;
