const AuthenticatedUser = require('../middleware/authenticated_user');
const asyncMiddleware = require('../classes/async-middleware.js');
const UserController = require('../controllers/user');

const UserMe = {
  route: '/user/me',
  wrapper: AuthenticatedUser, 
  get: asyncMiddleware(async function(req, res, next) {

    const user_id = req.acting_user.user_id;
    let user = await UserController.findByPk(user_id, {useMaster: false});
    res.result = [user];
    next();
  })
};

module.exports = UserMe;
