const admin_wrapper = require('../classes/admin_wrapper.js');

const error = require('../classes/error.js');
const asyncMiddleware = require('../classes/async-middleware.js');
const Notification = require('../api/notification');

const Handler = {
  route: '/user/notification',
  wrapper: admin_wrapper,
  post: asyncMiddleware(async function(req, res, next) {

    // const CampaignModel = TarlyController.getModel('campaign');
    let { user_ids, user_id, notification, campaign_name} = req.body;
    let campaign = {};
    for (let k of Object.keys(req.body)) {
      if (k.startsWith("campaign")) {
        campaign[k] = req.body[k];
      }
    }

    user_id = user_ids || user_id;
    if (!user_id){
      return next(new error.BadRequest('missing user_ids'));
    }
    if (!notification){
      return next(new error.BadRequest('missing notification'));
    }
    Notification.send(user_id, notification, campaign);
    next();
  })
};

module.exports = Handler;
