const asyncMiddleware = require('../classes/async-middleware.js');
const Notification = require('../api/notification');
const AuthenticatedUser = require('../middleware/authenticated_user');

const Handler = {
  route: '/user/notification/track',
  wrapper: AuthenticatedUser,
  post: asyncMiddleware(async function(req, res, next) {

    // const CampaignModel = TarlyController.getModel('campaign');
    let { notification, action } = req.body;
    let campaign = Object.assign({}, notification.campaign);

    await Notification.track(req.acting_user.user_id, "broadcast", action, campaign, notification);
    next();
  })
};

module.exports = Handler;
