const authenticatedUser = require('../middleware/authenticated_user.js');

const UserScene = {
  route: '/user/scene',
  wrapper: authenticatedUser,
  get: function(req, res, next) {
    res.result = {
      active: true,
      user_id: req.acting_user.user_id,
      widgets: [
        {
          cloned_id: "game",
          title: "Fortnite"
        }
      ]
    };
    return next();
  }
};

module.exports = UserScene;
