const TarlyController = require('../classes/tarly_controller');
const asyncMiddleware = require('../classes/async-middleware');
const uuidv4 = require('uuid/v4');
const logger = require('../api/logger');

module.exports = {
  route: '/user/settings',
  get: asyncMiddleware(async function(req, res, next) {
    const Model = TarlyController.getModel('user_settings').model;
    const user_id = req.acting_user.user_id;

    let [settings, ] = await Model.findOrCreate({
      where: {owner_id: user_id},
      defaults: { user_id, user_settings_id: uuidv4()}});
    settings = settings.get();
    settings = Object.assign(settings, settings.settings);
    delete settings.settings;
    delete settings.owner_id;
    res.result = [settings];
    return next();
  }),
  put: asyncMiddleware(async function(req, res, next) {

    const Model = TarlyController.getModel('user_settings').model;
    const user_id = req.acting_user.user_id;

    let [settings, ] = await Model.findOrCreate({
      where: {owner_id: user_id},
      defaults: { user_id, user_settings_id: uuidv4()}});

    for (let [k, v] of Object.entries(req.body)) {
      let jsonbKey = `settings.${k}`;
      if (v === null) {
        settings.set(jsonbKey, undefined);
      } else if (v !== settings.settings[k]) {
        settings.set(jsonbKey, v);
      }
    }
    await settings.save();

    settings = settings.get();
    settings = Object.assign(settings, settings.settings);
    delete settings.settings;
    delete settings.owner_id;
    res.result = [settings];
    return next();
  }),
};
module.exports.post = module.exports.put;
