const admin_wrapper = require('../classes/admin_wrapper.js');
const _ = require('lodash');

const cache = require('bebo-node-commons').RedisCache;
const config = require('../config.js');
const asyncMiddleware = require('../classes/async-middleware.js');
const Notification = require('../api/notification');
const DivisionController = require('../controllers/division');

const ONE_WEEK = 7 * 3600 * 24;

const Handler = {
  route: '/week/maint',
  wrapper: admin_wrapper,
  post: asyncMiddleware(async function(req, res, next) {

    const division_id = req.body.division_id;
    let standing = await DivisionController.getDivisionStanding(division_id);

    let top = standing[0];
    let teamname = top.team.name;
    let user_ids = [];

    let redisClient = await cache.getWriteClient(config.PUSH_REDIS_DB);

    let oldTop = await redisClient.getAsync(`top:${division_id}`);

    if (oldTop) {
      oldTop = JSON.parse(oldTop);
      if (oldTop.team.team_id === top.team.team_id) {
        res.code = 204;
        return next();
      }
    }
    await redisClient.setAsync(`top:${division_id}`, JSON.stringify(top), 'EX', ONE_WEEK);

    let usernames = [];
    for (let u of top.team.users) {
      usernames.push(u.username);
    }
    usernames = _.join(usernames, ", ");

    for (let i = 1; i < standing.length; i++) {
      let s = standing[i];
      for (let u of s.team.users) {
        user_ids.push(u.user_id);
      }
    }
    let notification = {
      "title": "New King Of The Hill!",
      "message": `${usernames} in team ${teamname} \nare now #1 !`,
      "icon_url": "https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/llama_tournament_logo.png"
    };
    let campaign_name = "king_of_the_hill";
    Notification.send(user_ids, notification, {campaign_name});

    next();
  })
};

module.exports = Handler;
