const uuidv4 = require('uuid/v4');
const Broadcast = require('../api/broadcast');
const logger = require('../api/logger');

const METHODS = new Set(['PUT', 'POST', 'DELETE']);

function emitEvent(req, res, next) {
  if (res.statusCode !== 200) {
    return next();
  }

  if (!METHODS.has(req.method)) {
    return next();
  }

  if (!res.result || !res.result.length > 0 || !res.result[0]) {
    return next();
  }

  const url = req.originalPath;

  let entity = { url };
  if (res.result[0].toJSON) {
    entity = Object.assign(entity, res.result[0].toJSON());
  } else {
    entity = Object.assign(entity, res.result[0]);
  }
  // ugly, but we need to remove this stuff
  delete entity.access_token;

  const entityIdName = `${url.split('/')[1]}_id`;
  const id = entity[entityIdName];
  const payload = {
    result: [entity],
    event_id: uuidv4(),
    current_at: Date.now()
  };

  Broadcast.emit(url, id, payload)
    .catch(err => {
      logger.error('Broadcast.emit', err.code, err.message);
    });
  next();
}

module.exports = emitEvent;
