const _ = require('lodash');
const logger = require('../api/logger');
const error = require('../classes/error.js');
const Sequelize = require("sequelize");

const RESERVED_QUERY_ARGS = new Set([
  'before',
  'after',
  'show_deleted',
  'count',
  'offset',
  'order']);

const queryToSQLOptions =  async function queryToSQLOptions(req, res, next) {

  req.query.count = parseInt(req.query.count);
  if (!req.query.count) {
    req.query.count = 20;
  }

  req.query.offset = parseInt(req.query.offset);
  if (!req.query.offset) {
    req.query.offset = 0;
  }

  req.query.order = req.query.order ? `${req.query.order}` : 'recent';

  // TODO: we should not do defaults here - but on the model layer
  //       on the model layer we can pick up configured values

  let sqlOptions = {plain: false};
  sqlOptions.limit = req.query.count || 100;
  sqlOptions.offset = req.query.offset || 0;
  let order;
  if ( req.query.order === 'recent') {
    order = [['updated_dttm', 'DESC']];
  } else if (req.query.order) {
    try {
      order = JSON.parse(req.query.order);
      // FIXME unsafe - need to validate DESC / ASC as not escaped
    } catch (err) {
      logger.error(err, req.query.order);
      return next(new error.BadRequest("order is not json"));
    }
  }
  if (order) {
    sqlOptions.order = order;
  }
  const showDeleted = (req.query.show_deleted || false);
  sqlOptions.paranoid = ! showDeleted;
  let where = {};

  if (req.is_admin && req.query.where) {
    where = JSON.parse(req.query.where);
    delete req.query.where;
  }

  where = Object.assign({}, _.omitBy(req.query, (v, k) => RESERVED_QUERY_ARGS.has(k)), where);

  for (let [key, value] of Object.entries(where)) {
    if (value === "null") {
      where[key] = { [Sequelize.Op.eq]: null };
    }
  }

  if (req.query.after || req.query.before) {
    where.updated_dttm = {};
    if (req.query.after) {
      where.updated_dttm.$gte = Date.parse(req.query.after);
    }
    if (req.query.before) {
      where.updated_dttm.$lte = Date.parse(req.query.before);
    }
  }
  if (Object.keys(where).length > 0) {
    sqlOptions.where = where;
  }
  req.sqlOptions = sqlOptions;

  next();
};
module.exports = queryToSQLOptions;
