'use strict';

var cluster = require('cluster');
var os = require('os');
var config = require('./api/config');
var logger = require('./api/logger');
var PharahApp = null;

async function Pharah() {
  var app = await PharahApp();
  var server = app.listen(config.PORT, function() {
    var port = server.address().port;
    logger.log(`Pharah listening on ${port} -- ${config.PORT}`);
  });
}

async function startCluster() {
  await config.init({name: "pharah"});
  if (PharahApp == null) {
    PharahApp = require('./pharah_app.js');
  }
  if (cluster.isMaster) {
    // Count the machine's CPUs
    var cpuCount = config.isLocal ? 1 : os.cpus().length;

    // Create a worker for each CPU
    for (var i = 0; i < cpuCount; i += 1) {
      cluster.fork();
    }

    // Listen for dying workers
    cluster.on('exit', function(worker) {
      // Replace the dead worker,
      // we're not sentimental
      logger.error('Worker %d died :(', worker.id);
      cluster.fork();
    });
  } else {
    Pharah();
  }
}

startCluster();
