async function main() {

  const { promisify } = require('util');
  const RedisLock = require('redlock');

  const config = require('./api/config');
  await config.init({name: "pharah"});

  config.CODE_NAME += '-redis_expire_listener';
  config.name += '-redis_expire_listener';

  const logger = require('./api/logger');
  await logger.init(config);

  const PharahClient = require('./tinder/pharah_client');
  const cache = require('bebo-node-commons').RedisCache;
  const lockClient = cache.getWriteClient(config.USER_STATE_REDIS_DB);
  const subClient = cache.getReadClient(config.USER_STATE_REDIS_DB);

  //Pub/Sub Redis clients cannot be re-used for anything else, thus we need to create 2 clients

  const Lock = new RedisLock([lockClient], {
    driftFactor: 0.01,
    retryCount: 0,
    retryDelay: 200,
    retryJitter: 200
  });

  subClient.send_command('config', ['set', 'notify-keyspace-events', 'Ex'], SubscribeExpired);

  function SubscribeExpired(e, r) {
    const expired_subKey = '__keyevent@6__:expired';
    subClient.subscribe(expired_subKey, function() {
      logger.info('Subscribed to "' + expired_subKey + '" event channel : ' + r);
      subClient.on('message', function(chan, msg) {
        if (msg.startsWith('user_state:')) {
          logger.info('[expired]', msg);
          const lock_key = 'expire_' + msg;
          logger.info('attempting to lock', lock_key);
          Lock.lock(lock_key, 1000)
            .then(lock => {
              // console.log('locked on', msg);
              const [_, tag] = msg.split(':');
              const [service, user_id] = tag.split('_');

              logger.info(`Deleting user_state ${service} for ${user_id}`);
              return PharahClient.delete(`/user/state/${service}`, {
                user_id
              }).then(() => lock.unlock());
            })
            .catch(err => {
              if (err.name != 'LockError') {
                throw err;
              } else {
                logger.debug('Failed to lock', msg, '-- someone else has it');
              }
            });
        }
      });
    });
  }
};
main();
