--
-- PostgreSQL database dump
--

-- Dumped from database version 9.6.1
-- Dumped by pg_dump version 9.6.10

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: enum_tournament_type; Type: TYPE; Schema: public; Owner: varys
--

CREATE TYPE public.enum_tournament_type AS ENUM (
    'storm'
);


ALTER TYPE public.enum_tournament_type OWNER TO varys;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: access_token; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.access_token (
    owner_id character varying(255),
    access_token_id character varying(255) NOT NULL,
    user_id character varying(255) NOT NULL,
    access_token character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.access_token OWNER TO varys;

--
-- Name: app_settings; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.app_settings (
    user_id text NOT NULL,
    data jsonb,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.app_settings OWNER TO varys;

--
-- Name: bot_commands; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.bot_commands (
    command_id text NOT NULL,
    stream_id text,
    keyword text,
    message text,
    active boolean,
    is_help boolean,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.bot_commands OWNER TO varys;

--
-- Name: bran_deploy; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.bran_deploy (
    type text NOT NULL,
    game text NOT NULL,
    bebo_env text NOT NULL,
    detector_id text,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.bran_deploy OWNER TO varys;

--
-- Name: bran_detector; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.bran_detector (
    id text NOT NULL,
    bebo_env text,
    type text,
    game text,
    version text,
    detector_file text,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.bran_detector OWNER TO varys;

--
-- Name: campaign; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.campaign (
    id integer NOT NULL,
    owner_id character varying(255),
    campaign_id character varying(255),
    code character varying(255) NOT NULL,
    utm_content character varying(255),
    division_id character varying(255),
    team_id character varying(255),
    viral_user_id character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.campaign OWNER TO varys;

--
-- Name: campaign_id_seq; Type: SEQUENCE; Schema: public; Owner: varys
--

CREATE SEQUENCE public.campaign_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.campaign_id_seq OWNER TO varys;

--
-- Name: campaign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: varys
--

ALTER SEQUENCE public.campaign_id_seq OWNED BY public.campaign.id;


--
-- Name: chat; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.chat (
    chat_id text NOT NULL,
    stream_id text,
    message text,
    _user jsonb,
    meta jsonb,
    priority integer,
    raw jsonb,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.chat OWNER TO varys;

--
-- Name: division; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.division (
    owner_id character varying(255),
    division_id character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone,
    image_url character varying(255) DEFAULT NULL::character varying
);


ALTER TABLE public.division OWNER TO varys;

--
-- Name: event; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.event (
    event_id text NOT NULL,
    name text,
    description text,
    image_url text,
    type text,
    data jsonb,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.event OWNER TO varys;

--
-- Name: filter; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.filter (
    filter_id text NOT NULL,
    filter_type text,
    name text,
    description text,
    properties jsonb,
    video boolean,
    audio boolean,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.filter OWNER TO varys;

--
-- Name: friend; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.friend (
    id integer NOT NULL,
    owner_id character varying(255),
    friend_id character varying(255) NOT NULL,
    user_id character varying(255) NOT NULL,
    deleted_dttm timestamp with time zone,
    blocked_dttm timestamp with time zone,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL
);


ALTER TABLE public.friend OWNER TO varys;

--
-- Name: friend_id_seq; Type: SEQUENCE; Schema: public; Owner: varys
--

CREATE SEQUENCE public.friend_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.friend_id_seq OWNER TO varys;

--
-- Name: friend_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: varys
--

ALTER SEQUENCE public.friend_id_seq OWNED BY public.friend.id;


--
-- Name: games; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.games (
    game_id text NOT NULL,
    name text,
    cloned_id text,
    source_id text,
    source_name text,
    popularity integer,
    image_url text,
    capture_settings jsonb,
    instructions text,
    verified boolean,
    deleted boolean,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone,
    cover_updated_dttm timestamp with time zone
);


ALTER TABLE public.games OWNER TO varys;

--
-- Name: hotkey; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.hotkey (
    hotkey_id text NOT NULL,
    keybind text,
    api text,
    url text,
    params text[],
    method text,
    created_dttm timestamp with time zone,
    updated_at timestamp with time zone
);


ALTER TABLE public.hotkey OWNER TO varys;

--
-- Name: invite; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.invite (
    owner_id character varying(255),
    invite_id character varying(255) NOT NULL,
    code character varying(255) NOT NULL,
    division_id character varying(255),
    team_id character varying(255),
    viral_user_id character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.invite OWNER TO varys;

--
-- Name: live_service; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.live_service (
    owner_id character varying(255),
    live_service_id character varying(255) NOT NULL,
    name text,
    bebo_env text,
    version text,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.live_service OWNER TO varys;

--
-- Name: lobby; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.lobby (
    owner_id character varying(255),
    lobby_id character varying(255) NOT NULL,
    division_id text NOT NULL,
    owner_user_id text NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.lobby OWNER TO varys;

--
-- Name: match; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.match (
    owner_id character varying(255),
    match_id character varying(255) NOT NULL,
    division_id character varying(255) NOT NULL,
    victory boolean DEFAULT false,
    data jsonb,
    opponent_scores integer[] DEFAULT ARRAY[]::integer[],
    challenger_scores integer[] DEFAULT ARRAY[]::integer[],
    round integer DEFAULT 1,
    state character varying(255) DEFAULT 'waiting'::character varying,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone,
    outcome text
);


ALTER TABLE public.match OWNER TO varys;

--
-- Name: match_set; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.match_set (
    owner_id character varying(255),
    match_set_id character varying(255) NOT NULL,
    match_id character varying(255) NOT NULL,
    set_id character varying(255) NOT NULL,
    type text NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.match_set OWNER TO varys;

--
-- Name: payment; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.payment (
    user_id text NOT NULL,
    token text NOT NULL,
    type text,
    ip text,
    updated_dttm timestamp with time zone,
    deleted_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.payment OWNER TO varys;

--
-- Name: scene_transition; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.scene_transition (
    scene_transition_id text NOT NULL,
    stream_transition_id text,
    stream_id text,
    previous_scene_id text,
    next_scene_id text
);


ALTER TABLE public.scene_transition OWNER TO varys;

--
-- Name: scene_widget; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.scene_widget (
    widget_id text NOT NULL,
    scene_id text NOT NULL,
    resolution text,
    name text,
    device_id text,
    "position" jsonb,
    cap_settings jsonb,
    visible boolean,
    locked boolean,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.scene_widget OWNER TO varys;

--
-- Name: service; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.service (
    owner_id character varying(255),
    service_id character varying(255) NOT NULL,
    name text,
    bebo_env text,
    version text,
    env text[],
    health_port integer,
    volumes text[],
    live_deploy boolean,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.service OWNER TO varys;

--
-- Name: set; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.set (
    owner_id character varying(255),
    set_id character varying(255) NOT NULL,
    division_id character varying(255) NOT NULL,
    scores jsonb[] DEFAULT ARRAY[]::jsonb[],
    started_dttm timestamp with time zone,
    ended_dttm timestamp with time zone,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone,
    simulation_id text
);


ALTER TABLE public.set OWNER TO varys;

--
-- Name: set_user; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.set_user (
    owner_id character varying(255),
    set_user_id character varying(255) NOT NULL,
    set_id character varying(255) NOT NULL,
    user_id character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.set_user OWNER TO varys;

--
-- Name: stream_clip; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_clip (
    stream_clip_id text NOT NULL,
    stream_id text,
    game_id text,
    reasons text[],
    duration numeric,
    media_url text,
    content_type text,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.stream_clip OWNER TO varys;

--
-- Name: stream_default_device; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_default_device (
    owner_id character varying(255),
    stream_default_device_id character varying(255) NOT NULL,
    webcam character varying(255) DEFAULT 'default'::character varying,
    mic character varying(255) DEFAULT 'default'::character varying,
    capture_card character varying(255) DEFAULT NULL::character varying,
    game_audio character varying(255) DEFAULT 'default'::character varying,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.stream_default_device OWNER TO varys;

--
-- Name: stream_follow_event; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_follow_event (
    event_id text NOT NULL,
    stream_id text,
    username text,
    social_id text,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.stream_follow_event OWNER TO varys;

--
-- Name: stream_hotkey; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_hotkey (
    stream_hotkey_id text NOT NULL,
    stream_id text,
    user_id text,
    hotkey_id text,
    keybind text,
    data jsonb,
    created_dttm timestamp with time zone,
    updated_at timestamp with time zone,
    key_obj jsonb
);


ALTER TABLE public.stream_hotkey OWNER TO varys;

--
-- Name: stream_round; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_round (
    owner_id character varying(255),
    stream_round_id character varying(255) NOT NULL,
    game_id text NOT NULL,
    start_dttm timestamp with time zone,
    end_dttm timestamp with time zone,
    verified boolean DEFAULT false,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.stream_round OWNER TO varys;

--
-- Name: stream_scene; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_scene (
    scene_id text NOT NULL,
    stream_id text,
    scene_name text,
    tags text[] DEFAULT ARRAY[]::text[],
    preview_img text,
    public boolean,
    background_img text,
    scene_hotkey_id text,
    template_id text,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone,
    widget_ids text[],
    active boolean,
    scene_order integer
);


ALTER TABLE public.stream_scene OWNER TO varys;

--
-- Name: stream_status; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_status (
    session_id text NOT NULL,
    stream_id text NOT NULL,
    minutes integer,
    test_stream boolean,
    stream_started_at timestamp with time zone,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.stream_status OWNER TO varys;

--
-- Name: stream_transition; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_transition (
    stream_transition_id text NOT NULL,
    stream_id text,
    transition_name text,
    duration numeric,
    split_time numeric,
    content_type text,
    public boolean,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone,
    media_url text
);


ALTER TABLE public.stream_transition OWNER TO varys;

--
-- Name: stream_variable; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_variable (
    variable_id text NOT NULL,
    stream_id text NOT NULL,
    value text,
    file_path text,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.stream_variable OWNER TO varys;

--
-- Name: stream_widget; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_widget (
    widget_id text NOT NULL,
    stream_id text NOT NULL,
    cloned_id text,
    title text,
    description text,
    image_url text,
    preview_image text,
    version text,
    cef_url text,
    type text,
    resolution text,
    codec text,
    name text,
    device_id text,
    cost integer,
    fps numeric,
    volume integer,
    active boolean,
    video boolean,
    audio boolean,
    "position" jsonb,
    data jsonb,
    cap_settings jsonb,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone,
    filter_ids text[]
);


ALTER TABLE public.stream_widget OWNER TO varys;

--
-- Name: stream_widget_filter; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.stream_widget_filter (
    stream_widget_filter_id text NOT NULL,
    stream_id text,
    filter_type text,
    name text,
    video boolean,
    audio boolean,
    properties jsonb,
    property_values jsonb,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone,
    input_stream_widget_ids text[]
);


ALTER TABLE public.stream_widget_filter OWNER TO varys;

--
-- Name: team; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.team (
    owner_id character varying(255),
    team_id character varying(255) NOT NULL,
    division_id character varying(255) NOT NULL,
    name character varying(255),
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.team OWNER TO varys;

--
-- Name: tournament; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.tournament (
    owner_id character varying(255),
    tournament_id character varying(255) NOT NULL,
    start_dttm timestamp with time zone NOT NULL,
    end_dttm timestamp with time zone,
    state character varying(255) DEFAULT 'upcoming'::character varying NOT NULL,
    image_url character varying(255) NOT NULL,
    background_url character varying(255),
    team_size integer DEFAULT 1 NOT NULL,
    name character varying(255) NOT NULL,
    prize_pool character varying(255),
    sponsors text[] DEFAULT ARRAY['bebo'::text],
    game_id character varying(255),
    type public.enum_tournament_type DEFAULT 'storm'::public.enum_tournament_type NOT NULL,
    scene_ids text[] DEFAULT ARRAY[]::text[],
    transition_id character varying(255),
    code text,
    discord_url text,
    description text,
    slug text,
    hidden boolean DEFAULT false,
    invited_broadcaster_type text[] DEFAULT ARRAY[]::text[],
    leaderboard jsonb DEFAULT '[]'::jsonb,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.tournament OWNER TO varys;

--
-- Name: tournament_cutoff; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.tournament_cutoff (
    owner_id character varying(255),
    tournament_cutoff_id character varying(255) NOT NULL,
    tournament_id text NOT NULL,
    offset_secs integer NOT NULL,
    players_percentage numeric NOT NULL,
    type text DEFAULT 'elim'::text,
    "order" integer NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.tournament_cutoff OWNER TO varys;

--
-- Name: tournament_prize; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.tournament_prize (
    owner_id character varying(255),
    tournament_prize_id character varying(255) NOT NULL,
    tournament_id text NOT NULL,
    title text NOT NULL,
    value integer NOT NULL,
    text text,
    "order" integer NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.tournament_prize OWNER TO varys;

--
-- Name: tournament_rule; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.tournament_rule (
    owner_id character varying(255),
    tournament_rule_id character varying(255) NOT NULL,
    tournament_id text NOT NULL,
    title text NOT NULL,
    text text NOT NULL,
    "order" integer NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.tournament_rule OWNER TO varys;

--
-- Name: tournament_team; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.tournament_team (
    owner_id character varying(255),
    tournament_team_id character varying(255) NOT NULL,
    tournament_id character varying(255) NOT NULL,
    usernames text[] DEFAULT ARRAY[]::text[] NOT NULL,
    player_stream_ids text[] DEFAULT ARRAY[]::text[] NOT NULL,
    player_victory integer[] DEFAULT ARRAY[]::integer[] NOT NULL,
    player_kill integer[] DEFAULT ARRAY[]::integer[] NOT NULL,
    rank integer,
    state text,
    name text DEFAULT ''::text NOT NULL,
    code text NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL
);


ALTER TABLE public.tournament_team OWNER TO varys;

--
-- Name: transaction; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.transaction (
    id text NOT NULL,
    stream_id text,
    type text,
    user_id text,
    amount text,
    currency text,
    transaction_id text,
    message text,
    note text,
    ip text,
    coin integer,
    anonymous boolean,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.transaction OWNER TO varys;

--
-- Name: user; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public."user" (
    owner_id character varying(255),
    user_id character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    username character varying(255) NOT NULL,
    password character varying(255) NOT NULL,
    image_url character varying(255),
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone,
    active_match_id text
);


ALTER TABLE public."user" OWNER TO varys;

--
-- Name: user_division; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_division (
    owner_id character varying(255),
    user_division_id character varying(255) NOT NULL,
    user_id character varying(255) NOT NULL,
    division_id character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.user_division OWNER TO varys;

--
-- Name: user_gallery; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_gallery (
    image_id text NOT NULL,
    img_url text,
    user_id text,
    width integer,
    height integer,
    name text,
    filetype text,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.user_gallery OWNER TO varys;

--
-- Name: user_game; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_game (
    owner_id character varying(255),
    user_game_id character varying(255) NOT NULL,
    user_id character varying(255) NOT NULL,
    started_dttm timestamp with time zone,
    ended_dttm timestamp with time zone,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.user_game OWNER TO varys;

--
-- Name: user_games; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_games (
    user_id text NOT NULL,
    game_id text NOT NULL,
    updated_dttm timestamp with time zone,
    bebo_id text
);


ALTER TABLE public.user_games OWNER TO varys;

--
-- Name: user_hardware; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_hardware (
    user_id text NOT NULL,
    device_id text NOT NULL,
    pnp_device_id text NOT NULL,
    type text,
    brand text,
    name text,
    data jsonb,
    created_dttm timestamp with time zone,
    updated_dttm timestamp with time zone
);


ALTER TABLE public.user_hardware OWNER TO varys;

--
-- Name: user_kill; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_kill (
    owner_id character varying(255),
    user_kill_id character varying(255) NOT NULL,
    no_value numeric DEFAULT 0,
    yes_value numeric DEFAULT 0,
    image_url character varying(255) NOT NULL,
    verified boolean DEFAULT false,
    game character varying(255) DEFAULT ''::character varying,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.user_kill OWNER TO varys;

--
-- Name: user_lobby; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_lobby (
    owner_id character varying(255),
    user_lobby_id character varying(255) NOT NULL,
    lobby_id text NOT NULL,
    user_id character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.user_lobby OWNER TO varys;

--
-- Name: user_social; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_social (
    user_id text NOT NULL,
    token text,
    refresh_token text,
    token_expires_dttm timestamp with time zone,
    token_secret text,
    type text NOT NULL,
    resolution text,
    bitrate integer,
    twitch_bitrate integer,
    fps integer,
    data jsonb,
    social_id text,
    stream_id text,
    active boolean,
    live boolean,
    bot_enable boolean,
    scopes text[],
    transport text,
    codec text,
    codec_settings jsonb,
    app_admin_mode boolean,
    encoder text,
    encoder_preset text,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone,
    max_upload integer,
    migration_dttm timestamp with time zone
);


ALTER TABLE public.user_social OWNER TO varys;

--
-- Name: user_team; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_team (
    owner_id character varying(255),
    user_team_id character varying(255) NOT NULL,
    user_id character varying(255) NOT NULL,
    team_id character varying(255) NOT NULL,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.user_team OWNER TO varys;

--
-- Name: user_victory; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.user_victory (
    owner_id character varying(255),
    user_victory_id character varying(255) NOT NULL,
    value numeric DEFAULT 0,
    image_url character varying(255) NOT NULL,
    verified boolean DEFAULT false,
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);


ALTER TABLE public.user_victory OWNER TO varys;

--
-- Name: watched_min; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.watched_min (
    dttm timestamp with time zone NOT NULL,
    id text NOT NULL,
    type text NOT NULL,
    stream_id text NOT NULL,
    data jsonb,
    value integer
);


ALTER TABLE public.watched_min OWNER TO varys;

--
-- Name: widget; Type: TABLE; Schema: public; Owner: varys
--

CREATE TABLE public.widget (
    cloned_id text NOT NULL,
    env text NOT NULL,
    public boolean,
    owner text,
    version text,
    description text,
    type text,
    widget_url text,
    audio boolean,
    video boolean,
    resolution text,
    fps integer,
    volume integer,
    panel_url text,
    "position" jsonb,
    data jsonb,
    project_url text,
    project_name text,
    updated_dttm timestamp with time zone,
    created_dttm timestamp with time zone
);


ALTER TABLE public.widget OWNER TO varys;

--
-- Name: campaign id; Type: DEFAULT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.campaign ALTER COLUMN id SET DEFAULT nextval('public.campaign_id_seq'::regclass);


--
-- Name: friend id; Type: DEFAULT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.friend ALTER COLUMN id SET DEFAULT nextval('public.friend_id_seq'::regclass);


--
-- Name: access_token access_token_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.access_token
    ADD CONSTRAINT access_token_pkey PRIMARY KEY (access_token_id);


--
-- Name: app_settings app_settings_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.app_settings
    ADD CONSTRAINT app_settings_pkey PRIMARY KEY (user_id);


--
-- Name: bot_commands bot_commands_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.bot_commands
    ADD CONSTRAINT bot_commands_pkey PRIMARY KEY (command_id);


--
-- Name: bran_deploy bran_deploy_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.bran_deploy
    ADD CONSTRAINT bran_deploy_pkey PRIMARY KEY (type, game, bebo_env);


--
-- Name: bran_detector bran_detector_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.bran_detector
    ADD CONSTRAINT bran_detector_pkey PRIMARY KEY (id);


--
-- Name: campaign campaign_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.campaign
    ADD CONSTRAINT campaign_pkey PRIMARY KEY (id);


--
-- Name: chat chat_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.chat
    ADD CONSTRAINT chat_pkey PRIMARY KEY (chat_id);


--
-- Name: division division_name_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.division
    ADD CONSTRAINT division_name_key UNIQUE (name);


--
-- Name: division division_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.division
    ADD CONSTRAINT division_pkey PRIMARY KEY (division_id);


--
-- Name: event event_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.event
    ADD CONSTRAINT event_pkey PRIMARY KEY (event_id);


--
-- Name: filter filter_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.filter
    ADD CONSTRAINT filter_pkey PRIMARY KEY (filter_id);


--
-- Name: friend friend_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.friend
    ADD CONSTRAINT friend_pkey PRIMARY KEY (id);


--
-- Name: games games_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.games
    ADD CONSTRAINT games_pkey PRIMARY KEY (game_id);


--
-- Name: hotkey hotkey_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.hotkey
    ADD CONSTRAINT hotkey_pkey PRIMARY KEY (hotkey_id);


--
-- Name: invite invite_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.invite
    ADD CONSTRAINT invite_pkey PRIMARY KEY (invite_id);


--
-- Name: live_service live_service_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.live_service
    ADD CONSTRAINT live_service_pkey PRIMARY KEY (live_service_id);


--
-- Name: lobby lobby_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.lobby
    ADD CONSTRAINT lobby_pkey PRIMARY KEY (lobby_id);


--
-- Name: match match_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.match
    ADD CONSTRAINT match_pkey PRIMARY KEY (match_id);


--
-- Name: match_set match_set_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.match_set
    ADD CONSTRAINT match_set_pkey PRIMARY KEY (match_set_id);


--
-- Name: payment payment_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.payment
    ADD CONSTRAINT payment_pkey PRIMARY KEY (user_id, token);


--
-- Name: scene_transition scene_transition_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.scene_transition
    ADD CONSTRAINT scene_transition_pkey PRIMARY KEY (scene_transition_id);


--
-- Name: scene_widget scene_widget_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.scene_widget
    ADD CONSTRAINT scene_widget_pkey PRIMARY KEY (widget_id, scene_id);


--
-- Name: service service_name_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.service
    ADD CONSTRAINT service_name_key UNIQUE (name);


--
-- Name: service service_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.service
    ADD CONSTRAINT service_pkey PRIMARY KEY (service_id);


--
-- Name: set set_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.set
    ADD CONSTRAINT set_pkey PRIMARY KEY (set_id);


--
-- Name: set_user set_user_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.set_user
    ADD CONSTRAINT set_user_pkey PRIMARY KEY (set_user_id);


--
-- Name: stream_clip stream_clip_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_clip
    ADD CONSTRAINT stream_clip_pkey PRIMARY KEY (stream_clip_id);


--
-- Name: stream_default_device stream_default_device_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_default_device
    ADD CONSTRAINT stream_default_device_pkey PRIMARY KEY (stream_default_device_id);


--
-- Name: stream_follow_event stream_follow_event_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_follow_event
    ADD CONSTRAINT stream_follow_event_pkey PRIMARY KEY (event_id);


--
-- Name: stream_hotkey stream_hotkey_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_hotkey
    ADD CONSTRAINT stream_hotkey_pkey PRIMARY KEY (stream_hotkey_id);


--
-- Name: stream_round stream_round_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_round
    ADD CONSTRAINT stream_round_pkey PRIMARY KEY (stream_round_id);


--
-- Name: stream_scene stream_scene_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_scene
    ADD CONSTRAINT stream_scene_pkey PRIMARY KEY (scene_id);


--
-- Name: stream_status stream_status_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_status
    ADD CONSTRAINT stream_status_pkey PRIMARY KEY (session_id, stream_id);


--
-- Name: stream_transition stream_transition_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_transition
    ADD CONSTRAINT stream_transition_pkey PRIMARY KEY (stream_transition_id);


--
-- Name: stream_variable stream_variable_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_variable
    ADD CONSTRAINT stream_variable_pkey PRIMARY KEY (variable_id, stream_id);


--
-- Name: stream_widget_filter stream_widget_filter_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_widget_filter
    ADD CONSTRAINT stream_widget_filter_pkey PRIMARY KEY (stream_widget_filter_id);


--
-- Name: stream_widget stream_widget_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.stream_widget
    ADD CONSTRAINT stream_widget_pkey PRIMARY KEY (widget_id, stream_id);


--
-- Name: team team_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.team
    ADD CONSTRAINT team_pkey PRIMARY KEY (team_id);


--
-- Name: tournament tournament_code_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament
    ADD CONSTRAINT tournament_code_key UNIQUE (code);


--
-- Name: tournament_cutoff tournament_cutoff_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament_cutoff
    ADD CONSTRAINT tournament_cutoff_pkey PRIMARY KEY (tournament_cutoff_id);


--
-- Name: tournament tournament_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament
    ADD CONSTRAINT tournament_pkey PRIMARY KEY (tournament_id);


--
-- Name: tournament_prize tournament_prize_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament_prize
    ADD CONSTRAINT tournament_prize_pkey PRIMARY KEY (tournament_prize_id);


--
-- Name: tournament_rule tournament_rule_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament_rule
    ADD CONSTRAINT tournament_rule_pkey PRIMARY KEY (tournament_rule_id);


--
-- Name: tournament tournament_slug_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament
    ADD CONSTRAINT tournament_slug_key UNIQUE (slug);


--
-- Name: tournament_team tournament_team_code_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament_team
    ADD CONSTRAINT tournament_team_code_key UNIQUE (code);


--
-- Name: tournament_team tournament_team_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.tournament_team
    ADD CONSTRAINT tournament_team_pkey PRIMARY KEY (tournament_team_id);


--
-- Name: transaction transaction_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.transaction
    ADD CONSTRAINT transaction_pkey PRIMARY KEY (id);


--
-- Name: user_division user_division_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_division
    ADD CONSTRAINT user_division_pkey PRIMARY KEY (user_division_id);


--
-- Name: user_division user_division_user_id_division_id; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_division
    ADD CONSTRAINT user_division_user_id_division_id UNIQUE (user_id, division_id);


--
-- Name: user user_email_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_email_key UNIQUE (email);


--
-- Name: user_gallery user_gallery_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_gallery
    ADD CONSTRAINT user_gallery_pkey PRIMARY KEY (image_id);


--
-- Name: user_game user_game_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_game
    ADD CONSTRAINT user_game_pkey PRIMARY KEY (user_game_id);


--
-- Name: user_games user_games_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_games
    ADD CONSTRAINT user_games_pkey PRIMARY KEY (user_id, game_id);


--
-- Name: user_hardware user_hardware_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_hardware
    ADD CONSTRAINT user_hardware_pkey PRIMARY KEY (user_id, device_id, pnp_device_id);


--
-- Name: user_kill user_kill_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_kill
    ADD CONSTRAINT user_kill_pkey PRIMARY KEY (user_kill_id);


--
-- Name: user_lobby user_lobby_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_lobby
    ADD CONSTRAINT user_lobby_pkey PRIMARY KEY (user_lobby_id);


--
-- Name: user_lobby user_lobby_user_id_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_lobby
    ADD CONSTRAINT user_lobby_user_id_key UNIQUE (user_id);


--
-- Name: user user_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_pkey PRIMARY KEY (user_id);


--
-- Name: user_social user_social_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_social
    ADD CONSTRAINT user_social_pkey PRIMARY KEY (user_id, type);


--
-- Name: user_team user_team_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_team
    ADD CONSTRAINT user_team_pkey PRIMARY KEY (user_team_id);


--
-- Name: user user_username_key; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_username_key UNIQUE (username);


--
-- Name: user_victory user_victory_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.user_victory
    ADD CONSTRAINT user_victory_pkey PRIMARY KEY (user_victory_id);


--
-- Name: watched_min watched_min_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.watched_min
    ADD CONSTRAINT watched_min_pkey PRIMARY KEY (dttm, id, type, stream_id);


--
-- Name: widget widget_pkey; Type: CONSTRAINT; Schema: public; Owner: varys
--

ALTER TABLE ONLY public.widget
    ADD CONSTRAINT widget_pkey PRIMARY KEY (cloned_id, env);


--
-- Name: access_token_access_token_user_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE UNIQUE INDEX access_token_access_token_user_id ON public.access_token USING btree (access_token, user_id);


--
-- Name: division_name; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX division_name ON public.division USING btree (name);


--
-- Name: friend_friend_id_user_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE UNIQUE INDEX friend_friend_id_user_id ON public.friend USING btree (friend_id, user_id);


--
-- Name: live_service_bebo_env; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX live_service_bebo_env ON public.live_service USING btree (bebo_env);


--
-- Name: live_service_name; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX live_service_name ON public.live_service USING btree (name);


--
-- Name: live_service_name_bebo_env_version; Type: INDEX; Schema: public; Owner: varys
--

CREATE UNIQUE INDEX live_service_name_bebo_env_version ON public.live_service USING btree (name, bebo_env, version);


--
-- Name: live_service_version; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX live_service_version ON public.live_service USING btree (version);


--
-- Name: lobby_set_division_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX lobby_set_division_id ON public.set USING btree (division_id);


--
-- Name: match_division_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX match_division_id ON public.match USING btree (division_id);


--
-- Name: match_set_match_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX match_set_match_id ON public.match_set USING btree (match_id);


--
-- Name: match_set_set_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX match_set_set_id ON public.match_set USING btree (set_id);


--
-- Name: service_bebo_env; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX service_bebo_env ON public.service USING btree (bebo_env);


--
-- Name: service_name; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX service_name ON public.service USING btree (name);


--
-- Name: service_name_bebo_env_version; Type: INDEX; Schema: public; Owner: varys
--

CREATE UNIQUE INDEX service_name_bebo_env_version ON public.service USING btree (name, bebo_env, version);


--
-- Name: service_version; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX service_version ON public.service USING btree (version);


--
-- Name: set_user_set_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX set_user_set_id ON public.set_user USING btree (set_id);


--
-- Name: tournament_code; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_code ON public.tournament USING btree (code);


--
-- Name: tournament_cutoff_tournament_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_cutoff_tournament_id ON public.tournament_cutoff USING btree (tournament_id);


--
-- Name: tournament_prize_tournament_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_prize_tournament_id ON public.tournament_prize USING btree (tournament_id);


--
-- Name: tournament_rule_tournament_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_rule_tournament_id ON public.tournament_rule USING btree (tournament_id);


--
-- Name: tournament_slug; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_slug ON public.tournament USING btree (slug);


--
-- Name: tournament_start_dttm; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_start_dttm ON public.tournament USING btree (start_dttm);


--
-- Name: tournament_state; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_state ON public.tournament USING btree (state);


--
-- Name: tournament_team_code; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_team_code ON public.tournament_team USING btree (code);


--
-- Name: tournament_team_name; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_team_name ON public.tournament_team USING btree (name);


--
-- Name: tournament_team_tournament_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_team_tournament_id ON public.tournament_team USING btree (tournament_id);


--
-- Name: tournament_team_username; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX tournament_team_username ON public.tournament_team USING btree (usernames);


--
-- Name: user_division_user_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_division_user_id ON public.user_division USING btree (user_id);


--
-- Name: user_division_user_id_deleted_dttm_division_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE UNIQUE INDEX user_division_user_id_deleted_dttm_division_id ON public.user_division USING btree (user_id, deleted_dttm, division_id);


--
-- Name: user_email; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_email ON public."user" USING btree (email);


--
-- Name: user_kill_no_value; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_kill_no_value ON public.user_kill USING btree (no_value);


--
-- Name: user_kill_verified; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_kill_verified ON public.user_kill USING btree (verified);


--
-- Name: user_kill_yes_value; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_kill_yes_value ON public.user_kill USING btree (yes_value);


--
-- Name: user_lobby_lobby_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_lobby_lobby_id ON public.user_lobby USING btree (lobby_id);


--
-- Name: user_lobby_user_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE UNIQUE INDEX user_lobby_user_id ON public.user_lobby USING btree (user_id);


--
-- Name: user_team_user_id_team_id; Type: INDEX; Schema: public; Owner: varys
--

CREATE UNIQUE INDEX user_team_user_id_team_id ON public.user_team USING btree (user_id, team_id);


--
-- Name: user_username; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_username ON public."user" USING btree (username);


--
-- Name: user_victory_value; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_victory_value ON public.user_victory USING btree (value);


--
-- Name: user_victory_verified; Type: INDEX; Schema: public; Owner: varys
--

CREATE INDEX user_victory_verified ON public.user_victory USING btree (verified);


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: varys
--

REVOKE ALL ON SCHEMA public FROM rdsadmin;
REVOKE ALL ON SCHEMA public FROM PUBLIC;
GRANT ALL ON SCHEMA public TO varys;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

