ALTER TABLE public.invite
  ADD COLUMN campaign_id character varying(255) NOT NULL,
  ADD COLUMN league_id character varying(255) DEFAULT NULL,
  ADD COLUMN campaign_content character varying(255) DEFAULT NULL,
  ADD COLUMN expire_dttm TIMESTAMP DEFAULT NULL;

ALTER TABLE public.campaign
    DROP COLUMN id,
    DROP COLUMN code,
    DROP COLUMN utm_content,
    DROP COLUMN division_id,
    DROP COLUMN team_id,
    DROP COLUMN viral_user_id;

ALTER TABLE public.campaign
    ADD COLUMN name character varying(255) NOT NULL,
    ADD COLUMN source character varying(255) DEFAULT '' NOT NULL,
    ADD COLUMN medium character varying(255) DEFAULT '' NOT NULL;

CREATE UNIQUE INDEX campaign_composite ON public.campaign 
    USING btree (name, source, medium);

/* applied */
ALTER TABLE public.team
    ADD COLUMN league_id character varying(255) NOT NULL;
ALTER TABLE public.user
    ADD COLUMN campaign jsonb DEFAULT '{"name": "organic"}'::jsonb;
CREATE TABLE public.league (
    name character varying(255),
    description TEXT,
    image_url character varying(255),
    timezone TEXT DEFAULT 'America/Los_Angeles',
    created_dttm timestamp with time zone NOT NULL,
    updated_dttm timestamp with time zone NOT NULL,
    deleted_dttm timestamp with time zone
);

ALTER TABLE public.league
    ADD COLUMN league_id character varying(255) NOT NULL,
    ADD COLUMN owner_id character varying(255) DEFAULT NULL;
CREATE UNIQUE INDEX league_league_id ON public.league USING btree(league_id);

INSERT INTO public.league 
  (league_id, name, created_dttm, updated_dttm)
  VALUES ('f838264d-cc4e-425d-8805-9c20606e3d41', 'bebo test', NOW(), NOW());

ALTER TABLE public.division
  ADD COLUMN league_id character varying(255) NOT NULL DEFAULT 
  'f838264d-cc4e-425d-8805-9c20606e3d41';
ALTER TABLE public.division
  ALTER COLUMN league_id DROP DEFAULT;

CREATE TABLE IF NOT EXISTS "user_league" 
             ( 
                          "owner_id"                    VARCHAR(255), 
                          "user_league_id"              VARCHAR(255) NOT NULL , 
                          "user_id"                     VARCHAR(255) NOT NULL, 
                          "league_id"                   VARCHAR(255) NOT NULL, 
                          "created_dttm" TIMESTAMP with time zone NOT NULL, 
                          "updated_dttm" timestamp WITH time zone NOT NULL, 
                          "deleted_dttm" timestamp WITH time zone, 
                          PRIMARY KEY ("user_league_id") 
             );
CREATE UNIQUE INDEX user_league_composite ON "user_league" USING btree(user_id, league_id);

ALTER TABLE "user_team" ADD COLUMN "league_id" VARCHAR(255) NOT NULL;
CREATE UNIQUE INDEX user_team_user_league_unique ON "user_team" USING btree(user_id, league_id);
