CREATE TABLE IF not EXISTS "msg_audit" (
  "owner_id"                VARCHAR(255),
  "msg_audit_id"            text,
  "external_id"             text NOT NULL,
  "type"                    text NOT NULL,
  "body"                    text NOT NULL,
  "from"                    text,
  "status"                  text NOT NULL,
  "to"                      text NOT NULL,
  "account_sid"             text NOT NULL,
  "api_version"             text NOT NULL,
  "direction"               text,
  "error_code"              INTEGER,
  "error_message"           text,
  "messaging_service_sid"   text,
  "num_media"               INTEGER,
  "num_segments"            INTEGER,
  "price"                   INTEGER,
  "price_unit"              text,
  "uri"                     text,
  "subresource_uris"        jsonb,
  "sent_dttm"               timestamp WITH    TIME zone DEFAULT NULL,
  "created_dttm"            timestamp WITH TIME zone NOT NULL,
  "updated_dttm"            timestamp WITH TIME zone NOT NULL,
  "deleted_dttm"            timestamp WITH TIME zone,

  PRIMARY KEY ("msg_audit_id")
);
