/* DROP TABLE tournament; */
CREATE TABLE IF NOT EXISTS "tournament" 
  ("owner_id" VARCHAR(255),
   "tournament_id" VARCHAR(255) NOT NULL ,
   "league_id" VARCHAR(255) NOT NULL,
   "start_dttm" TIMESTAMP WITH TIME ZONE,
   "end_dttm" TIMESTAMP WITH TIME ZONE,
   "image_url" VARCHAR(255) DEFAULT 'https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_tournament.png',
   "name" VARCHAR(255) NOT NULL,
   "description" TEXT,
   "created_dttm" TIMESTAMP WITH TIME ZONE NOT NULL,
   "updated_dttm" TIMESTAMP WITH TIME ZONE NOT NULL,
   "deleted_dttm" TIMESTAMP WITH TIME ZONE,
   PRIMARY KEY ("tournament_id"));
CREATE INDEX tournament_league ON tournament USING btree (league_id);

ALTER TABLE team add column "active_tournament_id" VARCHAR(255);
ALTER TABLE match add column "tournament_id" VARCHAR(255) ;
ALTER TABLE match alter column "division_id" DROP NOT NULL;
ALTER TABLE set add column "tournament_id" VARCHAR(255) ;
ALTER TABLE set alter column "division_id" DROP NOT NULL;
ALTER TABLE match_set alter column "type" DROP NOT NULL;

/* DROP TABLE tournament_team; */
CREATE TABLE IF NOT EXISTS "tournament_team" (
    "owner_id" VARCHAR(255),
    "tournament_team_id" VARCHAR(255) NOT NULL ,
    "tournament_id" VARCHAR(255) NOT NULL,
    "team_id" VARCHAR(255) NOT NULL,
    "registered_dttm" TIMESTAMP WITH TIME ZONE DEFAULT NULL,
    "created_dttm" TIMESTAMP WITH TIME ZONE NOT NULL,
    "updated_dttm" TIMESTAMP WITH TIME ZONE NOT NULL,
    "deleted_dttm" TIMESTAMP WITH TIME ZONE,
PRIMARY KEY ("tournament_team_id"));
ALTER TABLE "tournament_team" ADD column "rank" INTEGER DEFAULT 0;
CREATE UNIQUE INDEX tournament_team_id ON tournament_team
    USING btree (tournament_id, team_id);

ALTER TABLE "league"
   ADD COLUMN "active_division_id" VARCHAR(255),
   ADD COLUMN "active_tournament_id" VARCHAR(255);

ALTER TABLE "tournament"
    ADD COLUMN "round" NUMERIC DEFAULT 0,
    ADD COLUMN "max_rounds" NUMERIC DEFAULT -1,
    ADD COLUMN "state" VARCHAR(255) DEFAULT 'created';

ALTER TABLE "set"
    ADD COLUMN "outcome" VARCHAR(255),
    ADD COLUMN "state" VARCHAR(255),
    ADD COLUMN "round" INTEGER,
    ALTER COLUMN "team_id" DROP DEFAULT;
