CREATE TABLE user_game_backup_diff_0022 AS SELECT
   user_game.*
FROM user_game
    JOIN user_game AS overlap_post
    ON user_game.user_id = overlap_post.user_id
        AND user_game.started_dttm < overlap_post.started_dttm
        AND user_game.ended_dttm > overlap_post.started_dttm
GROUP BY user_game.user_game_id
ORDER BY user_game.started_dttm desc;

/* get rid of overlaps */
UPDATE user_game
SET ended_dttm=d."overlap_post.started_dttm"
FROM 
    (SELECT
       user_game.user_game_id,
       user_game.owner_id,
       user_game.started_dttm,
       user_game.ended_dttm,
       MIN(overlap_post.started_dttm) as "overlap_post.started_dttm",
       MAX(user_game.ended_dttm - overlap_post.started_dttm) as before,
       MIN(overlap_post.started_dttm - user_game.started_dttm) as duration
    FROM user_game 
        JOIN user_game AS overlap_post
        ON user_game.user_id = overlap_post.user_id
            AND user_game.started_dttm < overlap_post.started_dttm
            AND user_game.ended_dttm > overlap_post.started_dttm
    GROUP BY user_game.user_game_id
    ORDER BY user_game.started_dttm desc) as d
WHERE d.user_game_id=user_game.user_game_id;

/* wait until we time out all sets */

/* CREATE TABLE set_backup_diff_0022 AS */
/* SELECT DISTINCT set.* */
/* from set */
/* LEFT JOIN match_set ON set.set_id=match_set.set_id */
/* JOIN match ON match.match_id=match_set.match_id */
/* WHERE 'null' = ANY(set.scores) */
/* UNION */
/* SELECT DISTINCT set.* */
/* from set */
/* JOIN match_set ON set.set_id=match_set.set_id */
/* JOIN match ON match.match_id=match_set.match_id */
/* WHERE array_length(set.scores, 1) != match.game_cnt */
/*   AND match.tournament_id IS NULL; */

/* /1* brute force re-calc *1/ */
/* update set */ 
/*   SET ended_dttm=null, state='started', scores = ARRAY[]::jsonb[] */
/* FROM */ 
/*     (SELECT DISTINCT set.* */
/*         from set */
/*         LEFT JOIN match_set ON set.set_id=match_set.set_id */
/*         JOIN match ON match.match_id=match_set.match_id */
/*         WHERE 'null' = ANY(set.scores) */
/*         UNION */
/*         SELECT DISTINCT set.* */
/*         from set */
/*         JOIN match_set ON set.set_id=match_set.set_id */
/*         JOIN match ON match.match_id=match_set.match_id */
/*         WHERE array_length(set.scores, 1) != match.game_cnt) as d */
/* WHERE d.set_id = set.set_id; */
