ALTER TABLE team 
  ADD COLUMN gold_cnt INT DEFAULT 0; 
ALTER TABLE team 
  ADD COLUMN silver_cnt INT DEFAULT 0; 

CREATE INDEX match_tournament_id ON match(tournament_id, tournament_bracket, tournament_round);

WITH medals AS (
  SELECT
      set.team_id AS team_id,
      COUNT(CASE WHEN set.outcome='win' THEN 1 END) as gold_cnt,
      COUNT(CASE WHEN set.outcome='loss' OR set.outcome='draw' THEN 1 END) as silver_cnt
  FROM
      tournament
      JOIN match ON match.tournament_id = tournament.tournament_id
          AND match.tournament_bracket = 'upper'
          AND tournament.round_cnt = match.tournament_round
      JOIN match_set ON match_set.match_id = match.match_id 
      JOIN set ON set.set_id = match_set.set_id
  GROUP BY set.team_id
)
UPDATE team
SET gold_cnt=medals.gold_cnt,
    silver_cnt=medals.silver_cnt
FROM medals
WHERE team.team_id=medals.team_id;

