const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'access_token',
  table_schema: {
    user_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    access_token: {
      type: Sequelize.STRING,
      allowNull: false
    }
  },
  table_indexes: [
    {
      unique: true,
      fields: ['access_token', 'user_id']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
