const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'campaign',
  table_schema: {
    name: {
      type: Sequelize.STRING,
      allowNull: false,
      defaultValue: false,
      unique: 'compositeNameVariant'
    },
    variant: {
      type: Sequelize.STRING,
      allowNull: false,
      defaultValue: "default",
      unique: 'compositeNameVariant'
    },
    medium: {
      type: Sequelize.STRING,
      allowNull: false,
      defaultValue: "push-desktop"
    },
    source: {
      type: Sequelize.STRING,
      allowNull: true
    },
    content: {
      type: Sequelize.TEXT,
      allowNull: true
    },
    notification: {
      type: Sequelize.JSONB,
      allowNull: true
    },
    notification_hash: {
      type: Sequelize.STRING,
      allowNull: true
    }
  },
  table_indexes: [
  ],
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
