const AdminAuth = require('../classes/admin_wrapper');
const _ = require('lodash');
const Sequelize = require('sequelize');

module.exports = {
  table_name: 'division',
  toJSON: function() {
    let json = _.omit(this.dataValues, 'owner_id');
    return json;
  },
  table_schema: {
    league_id: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    name: {
      type: Sequelize.STRING,
      allowNull: false,
      unique: true
    },
    image_url: {
      type: Sequelize.STRING,
      allowNull: true,
    }
  },
  table_indexes: [
    {
      name: 'division_name',
      fields: ['name']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
