const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'friend',
  table_schema: {
    user_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    friend_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    deleted_dttm: {
      type: Sequelize.DATE,
      defaultValue: null
    },
    blocked_dttm: {
      type: Sequelize.DATE,
      defaultValue: null
    }
  },
  table_indexes: [
    {
      unique: true,
      fields: ['friend_id', 'user_id']
    }
  ],
  //custom fields below,
  // postAuth: AdminAuth,
  // deleteAuth: AdminAuth,
  // putAuth: AdminAuth
  cacheTime: 1 
};
