const Sequelize = require('sequelize');
const AdminAuth = require('../classes/admin_wrapper');
const config = require('../config');

const crypto = require('crypto');

function mkCode () {
  let buf =  Buffer.alloc(8);
  let code = crypto.randomFillSync(buf).toString('Base64');
  // turn into base64url (url safe)
  code = code.replace(/\+/g, '-')
    .replace(/\//g, '_')
    .replace(/=/g, '');
  code = code.slice(0, 5);
  return code;
}

module.exports = {

  table_name: 'invite',
  table_schema: {
    code: {
      type: Sequelize.STRING,
      allowNull: false,
      defaultValue: mkCode
    },
    campaign_name: {
      type: Sequelize.STRING,
      defaultValue: "organic",
      allowNull: false
    },
    campaign_source: {
      type: Sequelize.STRING,
      allowNull: true
    },
    campaign_medium: {
      type: Sequelize.STRING,
      allowNull: true
    },
    campaign_content: {
      type: Sequelize.STRING,
      allowNull: true
    },
    league_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    team_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    viral_user_id: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    expire_dttm: {
      type: Sequelize.DATE,
      allowNull: true,
    },
  },
  getterMethods: {
    invite_url: function() {
      return `${config.WWW_URL}/i/${this.getDataValue('code')}`;
    },
  },
  relation: {
    team: [
      {
        table_name: 'team',
        foreignKey: 'team_id',
        otherKey: 'team_id',
        constraints: false,
      },
    ],
    league: [
      {
        table_name: 'league',
        foreignKey: 'league_id',
        otherKey: 'league_id',
        constraints: false,
      },
    ],
    user: [
      {
        table_name: 'user',
        foreignKey: 'viral_user_id',
        otherKey: 'user_id',
        constraints: false,
        as: 'viral_user',
      },
    ]
  },
  include: [{
    tableName: 'team',
  }, {
    tableName: 'league',
  }, {
    tableName: 'user',
    as: 'viral_user',
  }],
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
