const Sequelize = require('sequelize');
const AdminAuth = require('../classes/admin_wrapper');

module.exports = {

  table_name: 'league',
  table_schema: {
    name: {
      type: Sequelize.STRING,
      allowNull: false
    },
    description: {
      type: Sequelize.TEXT,
      allowNull: true
    },
    active_division_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    active_tournament_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    image_url: {
      type: Sequelize.STRING,
      defaultValue: "https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_league.png",
    },
    timezone: {
      type: Sequelize.TEXT,
      allowNull: true
    },
    division_size: {
      type: Sequelize.INTEGER,
      allowNull: false,
      defaultValue: 120,
    },
    team_size: {
      type: Sequelize.INTEGER,
      allowNull: false
    },
    game_id: {
      type: Sequelize.STRING,
      defaultValue: 'fortnite'
    }
  },
  relation: {
    team: [
      {
        through: {
          table_name: 'user_team',
          unique: false
        },
        foreignKey: 'league_id',
        otherKey: 'team_id',
        constraints: false
      }
    ],
  },
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
