const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'live_service',
  table_schema: {
    name: {
      type: Sequelize.TEXT
    },
    bebo_env: {
      type: Sequelize.TEXT
    },
    version: Sequelize.TEXT
  },
  table_indexes: [
    {
      name: 'live_service_name',
      fields: ['name']
    },
    {
      name: 'live_service_bebo_env',
      fields: ['bebo_env']
    },
    {
      name: 'live_service_version',
      fields: ['version']
    },
    {
      unique: true,
      fields: ['name', 'bebo_env', 'version']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
