const Sequelize = require('sequelize');

module.exports = {
  table_name: 'match',
  table_schema: {
    division_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    tournament_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    league_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    tournament_round: {
      type: Sequelize.INTEGER,
      allowNull: true
    },
    tournament_bracket: {
      type: Sequelize.STRING,
      allowNull: true
    },
    tournament_seed: {
      type: Sequelize.INTEGER,
      allowNull: true
    },
    tournament_type: {
      type: Sequelize.STRING,
      allowNull: true
    },
    tournament_score: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    tournament_order: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    data: {
      // TODO: delete me
      type: Sequelize.JSONB,
      defaultValue: null
    },
    state: {
      type: Sequelize.STRING,
      defaultValue: 'created'
    },
    outcome: {
      type: Sequelize.STRING,
      allowNull: true
    },
    round: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    game: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    game_cnt: {
      type: Sequelize.INTEGER,
      defaultValue: 3
    },
    viewer_names: {
      type: Sequelize.STRING,
      allowNull: true
    },
    viewer_cnt: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    game_id: {
      type: Sequelize.STRING,
      defaultValue: 'fortnite'
    }
  },
  table_indexes: [
    {
      name: 'match_division_id',
      fields: ['division_id']
    },
    {
      name: 'match_tournament_id',
      fields: ['tournament_id']
    },
    {
      name: 'match_league_id',
      fields: ['league_id']
    }
  ],
  associate: models => {
    models.match.belongsToMany(models.set, {
      through: {
        model: models.match_set,
        unique: false
      },
      foreignKey: 'match_id',
      otherKey: 'set_id',
      constraints: false,
      as: 'owner'
    });
    models.match.belongsToMany(models.set, {
      through: {
        model: models.match_set,
        unique: false
      },
      foreignKey: 'match_id',
      otherKey: 'set_id',
      constraints: false,
      as: 'sets'
    });
  },
  include: [
    {
      tableName: 'set',
      as: 'sets',
      attributes: [
        'created_dttm',
        'updated_dttm',
        'started_dttm',
        'ended_dttm',
        'round',
        'outcome',
        'state',
        'scores',
        'team_id',
        'set_id'
      ],
      through: { attributes: [] },
      include: [
        {
          tableName: 'team',
          as: 'team',
          attributes: ['name', 'team_id', 'image_url', 'league_id'],
          include: [
            {
              tableName: 'user',
              attributes: ['username', 'user_id', 'image_url', 'bio'],
              through: { attributes: [] }
            }
          ]
        }
      ]
    }
  ]
};
