const AdminAuth = require('../classes/admin_wrapper');
const Sequelize = require('sequelize');

module.exports = {
  table_name: 'match_set',
  table_schema: {
    match_id: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    set_id: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    type: {
      type: Sequelize.TEXT,
      allowNull: true
    }
  },
  table_indexes: [
    {
      name: 'match_set_match_id',
      fields: ['match_id']
    },
    {
      name: 'match_set_set_id',
      fields: ['set_id']
    }
  ],
  emit: [
    {
      tableName: 'match',
      foreignKey: 'match_id'
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
