const Sequelize = require('sequelize');

module.exports = {
  table_name: 'msg_audit',
  table_schema: {
    msg_audit_id: {
      type: Sequelize.TEXT,
      primaryKey: true,
    },
    external_id: {
      type: Sequelize.TEXT,
      allowNull: false,
    },
    type: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    body: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    from: {
      type: Sequelize.TEXT
    },
    status: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    to: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    account_sid: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    api_version: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    direction: {
      type: Sequelize.TEXT
    },
    error_code: {
      type: Sequelize.INTEGER
    },
    error_message: {
      type: Sequelize.TEXT
    },
    messaging_service_sid: {
      type: Sequelize.TEXT
    },
    num_media: {
      type: Sequelize.INTEGER,
    },
    num_segments: {
      type: Sequelize.INTEGER,
    },
    price: {
      type: Sequelize.INTEGER,
    },
    price_unit: {
      type: Sequelize.TEXT,
    },
    uri: {
      type: Sequelize.TEXT,
    },
    subresource_uris: {
      type: Sequelize.JSONB
      // media: /2010-04-01/Accounts/ACXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Messages/SMXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Media.json
    },
    sent_dttm: {
      type: Sequelize.DATE,
      defaultValue: null
    },
  },
  table_indexes: [
    {
      name: 'msg_audit_external_id_type',
      fields: ['external_id', 'type']
    }
  ]
};
