const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'service',
  table_schema: {
    name: {
      type: Sequelize.TEXT,
      unique: true
    },
    bebo_env: {
      type: Sequelize.TEXT
    },
    version: Sequelize.TEXT,
    env: Sequelize.ARRAY(Sequelize.TEXT),
    health_port: Sequelize.INTEGER,
    volumes: Sequelize.ARRAY(Sequelize.TEXT),
    live_deploy: Sequelize.BOOLEAN
  },
  table_indexes: [
    {
      name: 'service_name',
      fields: ['name']
    },
    {
      name: 'service_bebo_env',
      fields: ['bebo_env']
    },
    {
      name: 'service_version',
      fields: ['version']
    },
    {
      unique: true,
      fields: ['name', 'bebo_env', 'version']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
