const AdminAuth = require('../classes/admin_wrapper');
const Sequelize = require('sequelize');

module.exports = {
  table_name: 'set',
  table_schema: {
    division_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    tournament_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    team_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    scores: {
      type: Sequelize.ARRAY(Sequelize.JSONB),
      defaultValue: []
    },
    outcome: {
      type: Sequelize.STRING,
      defaultValue: null
    },
    state: {
      type: Sequelize.STRING,
      defaultValue: null
    },
    round: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    started_dttm: {
      type: Sequelize.DATE,
      defaultValue: null
    },
    ended_dttm: {
      type: Sequelize.DATE,
      defaultValue: null
    }
  },
  table_indexes: [
    {
      name: 'lobby_set_division_id',
      fields: ['division_id']
    }
  ],
  associate: models => {
    models.set.belongsTo(models.team, {
      foreignKey: 'team_id',
      as: 'team'
    });
    models.set.hasMany(models.set_view, {
      foreignKey: 'set_id',
    });
  },
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
