const Sequelize = require('sequelize');
const AdminAuth = require('../classes/admin_wrapper');

module.exports = {

  table_name: 'team',
  table_schema: {
    league_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    active_division_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    active_tournament_id: {
      type: Sequelize.STRING,
      allowNull: true
    },
    invite_url: {
      type: Sequelize.STRING,
      allowNull: true
    },
    name: {
      type: Sequelize.STRING,
      allowNull: true
    },
    gold_cnt: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    silver_cnt: {
      type: Sequelize.INTEGER,
      defaultValue: 0,
      allowNull: false
    },
    image_url: {
      type: Sequelize.STRING,
      defaultValue: "https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_team.png"
    },
    last_match_dttm: {
      type: Sequelize.DATE,
      defaultValue: new Date(0)
    }
  },
  relation: {
    "user": [
      {
        through: {
          // model implicit
          table_name: "user_team",
          unique: false,
        },
        foreignKey: 'team_id',
        otherKey: 'user_id',
        constraints: false,
      },
    ],
    "division": [
      {
        table_name: 'division',
        foreignKey: 'active_division_id',
        otherKey: 'division_id',
        constraints: false,
      }
    ],
    "tournament": [
      {
        table_name: 'division',
        foreignKey: 'active_tournament_id',
        otherKey: 'tournament_id',
        constraints: false,
      }
    ]
  },
  include: [{
    tableName: 'user',
    through: { attributes: [] },
  }, {
    tableName: 'tournament'
  }, {
    tableName: 'division'
  }],
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
