const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'tournament',
  table_schema: {
    league_id: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    start_dttm: {
      type: Sequelize.DATE,
      allowNull: false 
    },
    end_dttm: {
      type: Sequelize.DATE,
    },
    image_url: {
      type: Sequelize.STRING,
      allowNull: true 
    },
    name: {
      type: Sequelize.STRING,
      allowNull: false
    },
    description: {
      type: Sequelize.TEXT
    },
    type: {
      type: Sequelize.TEXT,
      allowNull: false 
    },
    config: {
      type: Sequelize.JSONB,
      defaultValue: {}
    },
    state: {
      type: Sequelize.STRING
    },
    round: {
      type: Sequelize.NUMERIC
    },
    round_cnt: {
      type: Sequelize.NUMERIC
    },
    next_round_dttm: {
      type: Sequelize.DATE,
      allowNull: true 
    },
    points_needed: {
      type: Sequelize.NUMERIC
    },
    prize: {
      type: Sequelize.TEXT
    }
  },
  table_indexes: [
    {
      name: 'division_name',
      fields: ['name']
    }
  ],
  relation: {
    team : [
      {
        through: {
          table_name: 'tournament_team',
          unique: false
        },
        foreignKey: 'tournament_id',
        otherKey: 'team_id',
        constraints: false
      }
    ],
  },
  include: [
  ],

  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth,
  //cache seconds below
  //cacheTime: 1 
};
