const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'tournament_cutoff',
  table_schema: {
    tournament_id: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    offset_secs: {
      type: Sequelize.INTEGER,
      allowNull: false
    },
    players_percentage: {
      type: Sequelize.NUMERIC,
      allowNull: false
    },
    type: {
      type: Sequelize.TEXT,
      defaultValue: 'elim'
    },
    order: {
      type: Sequelize.INTEGER,
      allowNull: false
    }
  },
  table_indexes: [
    {
      name: 'tournament_cutoff_tournament_id',
      fields: ['tournament_id']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth,
  //cache seconds below
  cacheTime: 30
};
